<?php
/* @var $this ZlecenieController */
/* @var $dataCsv array */
/* @var $dataZip array */

$this->pageTitle = 'Importuj zlecenia - ' . Yii::app()->name;

$this->breadcrumbs = array(
	'Zlecenia'=>array('admin'),
	'Importuj',
);

$begin = is_array($dataCsv);

function friendlySize($sz)
{
	static $SzLbl = array('bajtów', 'kB', 'MB', 'GB');
	$szI = (int)$sz;
	$sz = (float)$sz;
	$i = 0;
	for (; $i<count($SzLbl)-1 && $szI > 0; $i++)
	{
		$sz /= 1024.0;
		$szI = (int)($sz / 1024);
	}
	return sprintf('%.2f %s', $sz, $SzLbl[$i]);
}

function implodeAssocArray($array)
{
	$result = '';
	foreach ($array as $key => $value)
		$result .= $key . ' - ' . $value . ( $value === end($array) ? '' : ', ' );
	return $result;
}
?>

<h1>Importuj zlecenia</h1>

<pre><?php if (isset($DEBUG)) print_r($DEBUG); ?></pre>

<style type="text/css">
	.progress {
		background-color: #cecece;
		height: 20px;
		padding: 8px;
		width: 100%;
		border-radius: 10px;
	}
	.progress .bar {
		width: 1%;
		background-color: #3e76af;
		height: 100%;
		border-radius: 10px;
	}
	#log {
		max-height: 256px;
		overflow: auto;
		padding: 20px;
		background-color: #f3f3f3;
		margin: 5px;
		border-radius: 10px;
	}
	.error {
		color: red;
	}
	#log .ok {
		color: green;
	}
	#log .duplicate {
		color: rgb(0, 153, 255);
	}
	#help {
		border-color: rgba(0,0,200,0.4);
		background: rgba(0,0,200,0.25);
		border-radius: 10px;
	}
	#helpBar {
		font-weight: bold;
		font-size: 110%;
		cursor: pointer;
		color: rgba(0,0,200,0.8);
		position: relative;
	}
	#helpBar img {
		right: 0;
		position: absolute;
		top: -1px;
	}
	#helpBarArrow {
		width: 20px;
		display: inline-block;
	}
	#helpContent > div {
		margin-top: 11px;
	}
	#errors {
		border-color: rgba(200,0,0,0.4);
		background: rgba(200,0,0,0.25);
		border-radius: 10px;
	}
	#return, #cancel, #ready {
		cursor: pointer;
	}
</style>

<div class="flash-notice" id="help">
	<div id="helpBar"><span id="helpBarArrow">&#9654;</span>Pomoc<img src="<?php echo $this->module->assetsUrl; ?>/images/help.png" /></div>
	<div id="helpContent"><div>
		<p>Poniższy formularz pozwala nas szybki import bazy pytań i odpowiedzi zapisanych w arkuszu kalkulacyjnym.
			Plik powinien zawierać następujące kolumny, których kolejność jest dowolna.</p>
		<ul>
			<li><b>lp</b> - liczba porządkowa identyfikująca zlecenie w arkuszu. Wartość
				ta jest wykorzystywana do zlokalizowania obrazka dla zlecenia.
				Pomaga również zidentyfikować błędy podczas importowania zleceń.</li>
			<li><b>dziedzina</b> - Liczbowy identyfikator dziedziny.
				Obecnie możliwe wartości to: <i><?php echo implodeAssocArray(Dziedzina::listAll()); ?></i>.</li>
			<li><b>poziom</b> - podany liczbowo.
				Możliwe wartości to: <i><?php echo implodeAssocArray(Zlecenie::getPoziomArray()); ?></i>.</li>
			<li><b>kategoria</b> - kategoria zlecenia np. <i>Pierwiastki</i>, <i>Genetyka</i> itp.</li>
			<li><b>czas</b> - czas na wykonanie zlecenia przez ucznia wyrażony w sekundach.</li>
			<li><b>cena</b> - wysokość nagrody, wyrażona w złotówkach, za poprawne rozwiązanie zlecenia</li>
			<li><b>kara</b> - kara jaką ponosi uczeń za niewykonanie zlecenia wyrażona w procentach od ceny zlecenia.
				Gdy cena to 200, a kara 10 to kwota karty jest równa 10% z 200 zł = 20zł.
				Wartości ułamkowe typu 0.55 przetwarzane są na całkowite tj. 55.</li>
			<li><b>czyPrzetarg</b> - Wartość liczbowa określająca, czy zlecenie jest przetargiem.
				Możliwe wartości to <i>1 - Tak</i> lub <i>0 - Nie</i>.</li>
			<li><b>czyPlatforma</b> - czy zlecenie ma zostać wyeksportowane do platformy edukacyjnej.
				Możliwe wartości takie jak w <i>czyPrzetarg</i>.</li>
			<li><b>tresc</b> - treść zadania (może zawierać znaczniki html).</li>
			<li><b>czyEgzamin</b> - czy zlecenie może być wykorzystane przy losowaniu
				pytań egzaminacyjnych. Możliwe wartości jak w <i>czyPrzetarg</i>.</li>
			<li><b>jednostka</b> - jednostka w jakiej  wyraża się odpowiedź np. cm, %, kg</li>
			<li><b>odpowiedz...</b> - kolumna rozpoczynająca swoją nazwę od 'odpowiedz' reprezentuje jedno z możliwych rozwiązań zlecenia.
				Ilość podanych kolumn jest dowolna. Niewykorzystywane komórki należy pozostawić puste.</li>
			<li><b>jezyk</b> - jeżeli pole ustawione jest na wartość <i>1</i> to zlecenie
				traktowane jest jako zagraniczne. W przeciwnym wypadku wartośc należy pozostawić pustą.
				Gdy pole jest ustawione właściwości <i>czyEgzamin, czyPrzetarg</i> są zerowane.</li>
		</ul>
		<p>Pierwszy wiersz powinien zawierać nazwy kolumn. W przeciwnym wypadku program
			nie będzie w stanie określić która kolumna odpowiada za jaką wartość.<br/><br/>
			Akceptowane są następujące formaty plików:</p>
		<ul>
			<li><b>Comma Separated Values (*.csv)</b></li>
			<li><b>Skoroszyt programu Excel 97 - 2003 (*.xls)</b></li>
		</ul>
		<p>Obrazki można przesłać za pomocą oddzielnego archiwum ZIP w którym nazwa pliku odpowiada liczbie porządkowej (lp) zlecenia w arkuszu.
			Akceptowane formaty obrazów to <b>Portable Network Graphics (*.png), Joint Photographic Expert Group (*.jpg, *.jpeg), Graphics Interchange Format (*gif)</b>.
			Tak więc by przypisać obrazek do zlecenia o lp równym 5 należy w archiwum umieścić obrazek 5.jpg, 5.jpeg, 5.png lub 5.gif.<br/>
		Skoroszyty Excela pozwalają na załączanie zdjęć. By skorzystać z tej funkcjonalności należy wstawić obraz do arkusza i ustawić
		położenie (jego lewy górny róg) w wierszu zlecenia którego dotyczy. W przypadku gdy obraz jest zbyt duży można go swobodnie przeskalować
		do wysokości wiersza w którym się znajduje.<br/>
		<b>UWAGA!</b> Program Excel kompresuje przeskalowane obrazy należy wyłączyć kompresje obrazów w pliku (Plik -> Opcje -> Zaawansowane -> Nie kompresuj obrazów w pliku).</p>
		<h4>Szablony plików</h4>
		<p>By mieć stuprocentową pewność, że korzystasz z poprawnego formatu arkusza skorzystaj z poniższych szablonów.
		Pliki te mają wypełnione nazwy kolumn oraz ustawione odpowiednie opcje do eksportu obrazków.</p>
		<ul>
			<li><?php echo CHtml::link('template.csv', $this->createUrl('main/getFile', array('name'=>'template.csv')), array('target'=>'_blank')) ?></li>
			<li><?php echo CHtml::link('template.xls', $this->createUrl('main/getFile', array('name'=>'template.xls')), array('target'=>'_blank')) ?></li>
		</ul>
		<h4>Przykładowe pliki</h4>
		<ul>
			<li><?php echo CHtml::link('example.csv', $this->createUrl('main/getFile', array('name'=>'example.csv')), array('target'=>'_blank')) ?></li>
			<li><?php echo CHtml::link('example.xls', $this->createUrl('main/getFile', array('name'=>'example.xls')), array('target'=>'_blank')) ?></li>
			<li><?php echo CHtml::link('example.zip', $this->createUrl('main/getFile', array('name'=>'example.zip')), array('target'=>'_blank')) ?></li>
		</ul>
	</div></div>
</div>

<?php if (count($errors)) : ?>
<div class="flash-notice" id="errors">
	<?php foreach ($errors as $error) : ?>
	<div><?php echo $error; ?></div>
	<?php endforeach; ?>
</div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data" action="<?php echo $this->createUrl('import'); ?>">
<ol>
	<li>
		<h5>Arkusz ze zleceniami</h5>
		<?php if (!is_array($dataCsv)) : ?>
			<p>Rozpoznawane formaty to: CSV, XLS.</p>
			<p>
				<input id="csvUploader" name="files[]" type="file" />
				<div><?php echo CHtml::dropDownList('csv-encodeing', 'CP1250', $encodeings); ?></div>
			</p>
		<?php else : ?>
			<p>
				<?php echo $dataCsv['name'] . ' (' . friendlySize($dataCsv['size']) . ')'; ?>
			</p>
		<?php endif; ?>
		<?php if (isset($errors['csv']) && $errors['csv']) : ?>
			<p class="error">
				<?php echo $errors['csv']; ?>
			</p>
		<?php endif; ?>
	</li>
	<li>
		<h5>Archiwum ze zdjęciami (<i>opcjonalnie</i>)</h5>
		<?php if (!$begin && !is_array($dataZip)) : ?>
			<p>Rozpoznawane formaty to: ZIP.</p>
			<p><input id="csvUploader" name="files[]" type="file" /></p>
		<?php else : ?>
			<p>
				<?php echo is_array($dataZip) ? ($dataZip['name'] . ' (' . friendlySize($dataZip['size']) . ')') : '<i>Nie wybrano pliku.</i>'; ?>
			</p>
		<?php endif; ?>
		<?php if (isset($errors['zip']) && $errors['zip']) : ?>
			<p class="error">
				<?php echo $errors['zip']; ?>
			</p>
		<?php endif; ?>
	</li>
	<li>
		<h5>Wysyłanie</h5>
		<?php if (!$begin) : ?>
			<p>Musisz wysłać co najmniej arkusz ze zleceniami.</p>
			<p>
				<input class="buttonS bBlue" id="subitAll" name="upload" type="submit" value="Rozpocznij"/>
				<input class="buttonS bRed" id="return" type="button" value="Anuluj"/>
			</p>
		<?php else : ?>
			<p>
				<input class="buttonS bRed" id="cancel" type="button" value="Anuluj" />
				<input class="buttonS bBlue" id="ready" type="button" value="Gotowe" style="display:none" />
				<div>
					<div class="progress">
						<div class="bar"></div>
					</div>
					<div id="log" style="max-height:256px;overflow:auto">
					</div>
				</div>
			</p>
		<?php endif; ?>
	</li>
</ol>
</form>

<script type="text/javascript">
(function()
{
	var isBegin = <?php echo json_encode($begin); ?>;

	function log(type, msg)
	{
		$('#log').append(
			'<div class="' + type + '">' + msg + '</div>'
		);
		$('#log').animate({ scrollTop: $('#log').height()}, 100);
	}

	function processQueue()
	{
		$.ajax({
			url: '<?php echo $this->createUrl('import') ?>',
			type: 'POST',
			data: {
				process: 1,
			},
			success: function(data)
			{
				//console.log(data);
				if (data.error) {
					log('error', data.error);
					return;
				}
				else if (data.done) {
					$('.progress').fadeOut();
					$('#cancel').fadeOut(400, function(){
						$('#ready').fadeIn();
					})
				}
				else processQueue();
				for (var i in data.entres)
				{
					var entry = data.entres[i];
					log(entry.error != null ? 'error' : ( entry.ok ? 'ok' : 'duplicate' ),
						'#' + entry.lp + ' ' + (entry.error != null ? entry.error : ( entry.ok ? 'Dodano' : 'Duplikat' )));
				}
				$('.progress .bar').css('width', (data.processed/data.total*100)+'%');
			},
			error: function()
			{
				log('error', 'Wystapił krytyczny błąd');
			}
		});
	}

	$('#ready, #return').on('click', function(){
		window.location.href = '<?php echo $this->createUrl('admin') ?>';
		return false;
	});

	if (isBegin)
	{
		$('#cancel').on('click', function(){
			window.location.href = '<?php echo $this->createUrl('import', array('cancel'=>1)) ?>';
			return false;
		});
		processQueue();
	}

	var content = $('#helpContent');
	//console.log(content);
	var hidden = true;
	content.hide();
	$('#helpBar').click(function(){
		if (hidden) {
			hidden = false;
			$('#helpBarArrow').html('&#9660;');
			content.slideDown();
		}
		else {
			hidden = true;
			$('#helpBarArrow').html('&#9654;');
			content.slideUp()
		}
	});

})();
</script>
